/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.util.Version;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;

public class DrawingHistoryEntry
implements Serializable,
Cloneable {
    static final long serialVersionUID = 7910102556584883276L;
    private int serializedDataVersion = 1;
    protected Date fChangeDate;
    protected String fUser;
    protected Version fSoftwareVersion;
    protected String fChangeComment;
    protected boolean fSaved = false;
    private boolean fDeleted;

    public DrawingHistoryEntry() {
        this.setChangeDate(new Date());
        this.setUser(System.getProperty("user.name"));
        this.setSoftwareVersion(Version.getCurrentVersion());
    }

    public Date getChangeDate() {
        return this.fChangeDate;
    }

    public String getUser() {
        return this.fUser;
    }

    public Version getSoftwareVersion() {
        return this.fSoftwareVersion;
    }

    public void setChangeDate(Date changeDate) {
        this.fChangeDate = changeDate;
    }

    public void setUser(String user) {
        this.fUser = user;
    }

    public void setSoftwareVersion(Version version) {
        this.fSoftwareVersion = version;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getChangeDate().toString());
        buffer.append("; ");
        buffer.append(this.getUser());
        buffer.append("; ");
        buffer.append(this.getSoftwareVersion().getConfiguration().getCompany());
        buffer.append(this.getSoftwareVersion().toString());
        buffer.append(this.getSoftwareVersion().getVersionAddon().toString());
        return buffer.toString();
    }

    public String getChangeComment() {
        return this.fChangeComment;
    }

    public void setChangeComment(String comment) {
        this.fChangeComment = comment;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.fSaved = true;
        try {
            s.defaultWriteObject();
        }
        catch (IOException exception) {
            this.fSaved = false;
            throw exception;
        }
    }

    public boolean isSaved() {
        return this.fSaved;
    }

    public void setSaved(boolean saved) {
        this.fSaved = saved;
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public void setDeleted(boolean deleted) {
        this.fDeleted = deleted;
    }

    public boolean isDeleted() {
        return this.fDeleted;
    }
}

